#include(rules-wind.inc)

[top]
components : populationGen
in : dist-average-gen-one dist-average-ext-one
in : dist-average-gen-two dist-average-ext-two
in : dist-average-gen-three dist-average-ext-three
link : dist-average-gen-one inputDistAverageGenOne@populationGen
link : dist-average-ext-one inputDistAverageExtOne@populationGen
link : dist-average-gen-two inputDistAverageGenTwo@populationGen
link : dist-average-ext-two inputDistAverageExtTwo@populationGen
link : dist-average-gen-three inputDistAverageGenThree@populationGen
link : dist-average-ext-three inputDistAverageExtThree@populationGen


[populationGen]
type : cell
dim : (25,25)
delay : transport
defaultDelayTime : 100
border : wrapped 

neighbors : populationGen(0,0) 
neighbors : populationGen(-1,-1)  populationGen(1,1)  populationGen(-1,1)  populationGen(1,-1)
neighbors : populationGen(-2,-2)  populationGen(2,2)  populationGen(-2,2)  populationGen(2,-2)
neighbors : populationGen(-3,-3)  populationGen(3,3)  populationGen(-3,3)  populationGen(3,-3)
neighbors : populationGen(-2,0)  populationGen(-1,0)  populationGen(1,0)  populationGen(2,0)
neighbors : populationGen(0,-2)  populationGen(0,-1)  populationGen(0,1)  populationGen(0,2)
neighbors : populationGen(0,-3)  populationGen(-3,0)  populationGen(3,0)  populationGen(0,3)
neighbors : populationGen(1,3)  populationGen(1,2)  populationGen(1,-3)  populationGen(1,-2)
neighbors : populationGen(-1,3)  populationGen(-1,2)  populationGen(-1,-3)  populationGen(-1,-2)
neighbors : populationGen(3,1)  populationGen(2,1)  populationGen(3,-1)  populationGen(2,-1)
neighbors : populationGen(-3,1)  populationGen(-2,1)  populationGen(-3,-1)  populationGen(-2,-1)
neighbors : populationGen(2,3)  populationGen(2,-3)  populationGen(-2,3)  populationGen(-2,-3)
neighbors : populationGen(3,2)  populationGen(3,-2)  populationGen(-3,2)  populationGen(-3,-2)

in : inputDistAverageGenOne inputDistAverageExtOne
in : inputDistAverageGenTwo inputDistAverageExtTwo
in : inputDistAverageGenThree inputDistAverageExtThree

link : inputDistAverageGenOne in-gen-one@populationGen(4,4)
link : inputDistAverageExtOne in-ext-one@populationGen(8,8)
link : inputDistAverageGenTwo in-gen-two@populationGen(15,15)
link : inputDistAverageExtTwo in-ext-two@populationGen(5,15)
link : inputDistAverageGenThree in-gen-three@populationGen(18,15)
link : inputDistAverageExtThree in-ext-three@populationGen(10,15)

initialvalue : 0
initialCellsValue : init-2.val
stateVariables: hum act ext avggen avgext windup windright
stateValues: 0 0 0 0 0 10 -10
NeighborPorts: hum act ext avggen avgext windup windright

localtransition : population-gen
portInTransition : in-gen-one@populationGen(4,4) set-average-gen
portInTransition : in-ext-one@populationGen(8,8) set-average-ext
portInTransition : in-gen-two@populationGen(15,15) set-average-gen
portInTransition : in-ext-two@populationGen(5,15) set-average-ext
portInTransition : in-gen-three@populationGen(18,15) set-average-gen
portInTransition : in-ext-three@populationGen(10,15) set-average-ext

[population-gen]
rule :  { ~out := (0,0); ~ext := $ext; ~act := $act;
          ~avggen := $avggen;  ~avgext := $avgext;
 		  ~windup := $windup; ~windright := $windright; }
		100 {time = 0}
rule : 	{ ~out := 10; ~ext := $ext; ~act := $act;
          ~avggen := 0;  ~avgext := 0; }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := #macro(avggen-change); $avgext := #macro(avgext-change); } 
		{ if( #macro(blown-cld-in), 300, 100 ) }
		{ (#macro(blown-cld-in) AND $ext != 1) OR ( (0,0) = 10 AND NOT #macro(blown-cld-out) ) OR #macro(gen-cld) }
rule :  { ~out := 0; ~ext := $ext; ~act := $act; 
          ~avggen := 0;  ~avgext := 0; }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := #macro(avggen-change); $avgext := #macro(avgext-change); }
		{ if( #macro(blown-cld-out), 300, 200 ) }
		{ #macro(blown-cld-out) OR #macro(ext-cld) }
rule :  { ~out := 0; ~ext := $ext; ~act := $act;
          ~avggen := 0;  ~avgext := 0; }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := #macro(avggen-change); $avgext := #macro(avgext-change); } 
		100 {t}

[set-average-gen]
rule :  { ~out := (0,0); ~ext := $ext; ~act := $act;
          ~avggen := portValue(thisPort);  ~avgext := $avgext;
 		  ~windup := $windup; ~windright := $windright; }
		100 {time = 0}
rule : 	{ ~out := 10; ~ext := $ext; ~act := $act;
          ~avggen := portValue(thisPort);  ~avgext := 0; }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := $avggen + portValue(thisPort); $avgext := #macro(avgext-change); } 
		{ if( #macro(blown-cld-in), 100, 100 ) }
		{ #macro(blown-cld-in) OR (#macro(gen-cld) AND NOT #macro(blown-cld-out)) }
rule :  { ~out := 0; ~ext := $ext; ~act := $act; 
          ~avggen := portValue(thisPort);  ~avgext := 0; }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := $avggen + portValue(thisPort); $avgext := #macro(avgext-change); }
		{ if( #macro(blown-cld-out), 300, 300 ) }
		{ #macro(blown-cld-out) OR #macro(ext-cld) }
rule :  { ~out := 0; ~ext := $ext; ~act := $act;
          ~avggen := portValue(thisPort);  ~avgext := 0; }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := $avggen + portValue(thisPort); $avgext := #macro(avgext-change); } 
		100 {t}
		
[set-average-ext]
rule :  { ~out := (0,0); ~ext := $ext; ~act := $act;
          ~avggen := $avggen;  ~avgext := portValue(thisPort);
 		  ~windup := $windup; ~windright := $windright; }
		100 {time = 0}
rule : 	{ ~out := 10; ~ext := $ext; ~act := $act;
          ~avggen := 0;  ~avgext := portValue(thisPort); }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := #macro(avggen-change); $avgext := $avgext + portValue(thisPort); } 
		{ if( #macro(blown-cld-in), 300, 300 ) }
		{ #macro(blown-cld-in) OR (#macro(gen-cld) AND NOT #macro(blown-cld-out)) }
rule :  { ~out := 0; ~ext := $ext; ~act := $act; 
          ~avggen := 0;  ~avgext := portValue(thisPort); }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := #macro(avggen-change); $avgext := $avgext + portValue(thisPort); }
		{ if( #macro(blown-cld-out), 100, 500 ) }
		{ #macro(blown-cld-out) OR #macro(ext-cld) }
rule :  { ~out := 0; ~ext := $ext; ~act := $act;
          ~avggen := 0;  ~avgext := portValue(thisPort); }
		{ $hum := #macro(hum-change); $ext := #macro(ext-change); $act := #macro(act-change);
          $avggen := #macro(avggen-change); $avgext := $avgext + portValue(thisPort); } 
		100 {t}
